#ifndef _H_COutlineWindow
#define _H_COutlineWindow

#include "CDocument.h"
#include "O.h"

class	CFinderWindowHeader;

#define ADFS_MinCellHeight		18

class COutlineWindow : public CDocument {

	public:		Boolean	IOutlineWindow(
					ADFS_WindowType			windowType, 
					short					resourceID, 
					O_TopicRefP				topicRef);

	virtual		void	Dispose(void);
	
				OSErr	Prepare(void);
				void	UnPrepare(void);
	
	virtual		void	AdjustScrollbars(void);
	virtual		void	DoKeyDown(EventRecord *event);
	virtual		void	DoClick(EventRecord *event);
	virtual		void	DoTopicClick(O_CTopic *cTopic, Point hitPoint, short modifiers);
	virtual		void	InvalWindow(WindowRectType windowRect);
	virtual		void	Draw(void);
	virtual		void	PreDraw(void);
	virtual		void	PostDraw(long bottom);
	virtual		void	Idle(void);
	virtual		Boolean	DoCommand(long command);
	virtual		void	UpdateFontInfo(ADFS_FontRec *fontRec);

	virtual		void	DoPanWithHand(Point	hitPoint);

	virtual		void	UpdateMenus(void);

	virtual		void	DeSelectAll(void);
	
	virtual		Boolean	GetWindowHit(
		Point			thePoint, 
		WindowRectType	*pane, 
		short			*subPane, 
		O_CTopic		**topic, 
		Rect			*hitRect
	);
			
	virtual		Rect	GetWindowRect(WindowRectType wrType);

	static	long		S_OutlineWindowDispatchCB(
		O_TopicRefP				topicRef, 
		O_CBType				cbType, 
		O_CBDataP				cbData);

	virtual	long		OutlineWindowDispatchCB(
		O_TopicRefP		topicRef, 
		O_CBType		cbType, 
		O_CBDataP		cbData
	);

	void	GetLineAndPageScrolls(
		WindowRectType	scrollbar, 
		short			*line, 
		short			*page
	);

	virtual		Rect	GetScrollExtents(void);
	virtual		void	GetScrollMaxs(
		short	*hMax, 
		short	*vMax
	);

/*
	virtual		Boolean	CanAcceptDrag(DragReference theDrag);

	virtual	OSErr		DragTrack(
		DragTrackingMessage		message, 
		DragReference			theDragRef
	);

	virtual	OSErr		DragReceive(
		DragReference			theDragRef
	);
*/
	
	virtual	O_CTopic	*GetRootTopic(void);
	virtual	O_CTopic	*GetFirstTopic(void);
		
	CFinderWindowHeader			*i_header;

	O_TopicRef					i_topicRef;
	Boolean						i_owner;
	
	Boolean			i_usingOffscreens;
	Boolean			i_usingEraseRgns;

	O_CTopic		*i_dragHitTopic;

	private:
	typedef CDocument	_inherited;
};

#endif